/*==============================================================================
Replication package for the BPEA Spring 2024 paper:

"The Emergence of a Uniform Business Cycle in the United States: 
Evidence from New Claims-Based Unemployment Data"

Andrew Fieldhouse, David Munro, Christoffer Koch, and Sean Howard

Stata code creating the Bartik instrument (Bartik.dta) used in the Rep_Stata_LPIV.do replication package for Figure 5
==============================================================================*/

clear all

*Set Your Directory to Replication Package Folder:

* Andrew:
cd "/Users/afieldhouse/Dropbox/Research/Historical Claims Project/continuous_updates/Replication Package_BPEA_CBUR/Rep_Code/"

local dirdata "/Users/afieldhouse/Dropbox/Research/Historical Claims Project/continuous_updates/Replication Package_BPEA_CBUR/Rep_Data/"
local dircbur "/Users/afieldhouse/Dropbox/Research/Historical Claims Project/continuous_updates/Replication Package_BPEA_CBUR/CBUR Data/"

u "`dirdata'/SAINC5_1929_2022.dta", clear

bysort fips year: egen SumEarn=sum(gdp_ind_group_usd)

gen Ind_Share=gdp_ind_group_usd/SumEarn


egen id = group(fips match_id)
xtset id year

*5-year average industry shares
gen Ind_Share_MA=(F2.Ind_Share+F1.Ind_Share+Ind_Share+L1.Ind_Share+L2.Ind_Share)/5

*Gen national industry output leaving the individual states out
gen Agg_Ind_Other=.
levelsof fips
foreach lev in `r(levels)' {
di(`lev')

bysort match_id year: egen temp=sum(gdp_ind_group_usd) if fips!=`lev'
bysort match_id year: egen tempfill=max(temp)

bysort match_id year: replace Agg_Ind_Other=tempfill if fips==`lev'
drop temp tempfill

}

xtset id year
*generate growth rates for "leave state out" industry output
by id: gen LD_Agg_Ind_Other=ln(Agg_Ind_Other)-ln(L.Agg_Ind_Other)

*instrument for state industry growth (agg. industry growth (leave out) multiplied by state industry shares)
gen Ind_ShareXAgg_growth=Ind_Share_MA*LD_Agg_Ind_Other

*aggregate across all industry growth rates by state
bysort fips year: egen imix=sum(Ind_ShareXAgg_growth)

*find national growth rates
bysort year: egen imix_bar=mean(imix)

*find relative growth rates
gen rimix=imix-imix_bar

bysort fips year: gen keep_id=_n

keep if keep_id==1

drop POP POP_nat lnPOP lnPOP_nat relnPOP _merge

save "`dirdata'/Bartik_Full.dta", replace

replace rimix = . if year > 1999 & year < 2004

save "`dirdata'/Bartik_Baseline.dta", replace


